<?php

namespace Import\ApiBundle\Services\Import;


use Import\ApiBundle\Entity\GpwSession;
use Import\ApiBundle\Entity\GpwType;

class ImportGPW extends ImportMainService
{
    protected $columns = array("Name","Date","Open","High","Low","Close","Volume","Oi");

    protected $type = 'GPW';

    public function import()
    {
        $GpwTypes = $this->getGpwTypeAll();
        $count = 0;

        /** @var GpwType $GpwType */
        foreach($GpwTypes as $GpwType)
        {
            $count += $this->importForType($GpwType);
        }
        return array('count' => $count);
    }

    protected function importForType(GpwType $GpwType)
    {
        $type = $this->type.'_'.$GpwType->getSymbol();
        $data = $this->getCSVFromZip($GpwType->getImportUrl(),$type,$this->columns);

        $i = 0;
        foreach($data as $row)
        {
            $this->save($GpwType, $row);
            $i++;
        }

        $this->getDoctrine()->getEntityManager()->flush();
        $this->viewErrors();

        return $i;
    }

    protected function save(GpwType $GpwType, $data)
    {
        $GpwIndex = $this->getGpwIndexBySymbol($GpwType, $data['Name']);
        /** @var GpwSession $GpwSession */
        $GpwSession = $this->getDoctrine()->getRepository('ImportApiBundle:GpwSession')->add($GpwIndex, $data);
        $GpwIndex->addSession($GpwSession);
        $GpwSession->setIndex($GpwIndex);

        $this->getDoctrine()->getEntityManager()->persist($GpwIndex);

        return true;
    }
}